/******************************************************************************
* File:    vectors.h
*
* Purpose: Define interrupt vector table framework.
* Author:  Quinten Brooks, Freescale Semiconductor
* Email:   quinten.brooks@freescale.com
# Date:    2007.03.21
******************************************************************************/

#ifndef __VECTORS_H
#define __VECTORS_H     1

#define VECTOR_BASE     0x000000        //
#define VECTOR_000      entry_point     // Hardware Reset
#define VECTOR_001      entry_point     // COP Reset
#define VECTOR_002      default_isr     // CPU Illegal Instruction
#define VECTOR_003      default_isr     // CPU HW Stack Overflow
#define VECTOR_004      default_isr     // CPU Misaligned Long Access
#define VECTOR_005      default_isr     // CPU EOnCE Step Counter
#define VECTOR_006      default_isr     // CPU EOnCE Breakpoint Unit 0
#define VECTOR_007      default_isr     // CPU EOnCE Trace Buffer
#define VECTOR_008      default_isr     // CPU EOnCE TX Register Empty
#define VECTOR_009      default_isr     // CPU EOnCE RX Register Full
#define VECTOR_010      default_isr     // PMC Out Of Regulation
#define VECTOR_011      default_isr     // OCCS (Loss of Lock 0-1, Loss of Referece Clock)
#define VECTOR_012      default_isr     // ADCA Conversion Complete
#define VECTOR_013      default_isr     // ADCB Conversion Complete
#define VECTOR_014      default_isr     // PWM (Reload, Fault)
#define VECTOR_015      default_isr     // CMP0 (Flag Rising, Flag Falling)
#define VECTOR_016      default_isr     // CMP1 (Flag Rising, Flag Falling)
#define VECTOR_017      default_isr     // CMP2 (Flag Rising, Flag Falling)
#define VECTOR_018      default_isr     // HFM (Access Error, Command Complete, Buffer Empty)
#define VECTOR_019      default_isr     // SPI (RX Full, RX Overflow, RX Mode Fault)
#define VECTOR_020      default_isr     // SPI TX Empty
#define VECTOR_021      default_isr     // SCI (TX Empty, TX Idle)
#define VECTOR_022      default_isr     // SCI (RX Error, RX Full/Overrun)
#define VECTOR_023      iic_isr        // I2C (TX Complete, Match, Arb Lost, Timeout)
#define VECTOR_024      default_isr     // PIT
#define VECTOR_025      default_isr     // TMR0 (Compare, Overflow, Input Edge, Compare 1-2)
#define VECTOR_026      default_isr     // TMR1 (Compare, Overflow, Input Edge, Compare 1-2)
#define VECTOR_027      default_isr     // GPIOA
#define VECTOR_028      default_isr     // GPIOB
#define VECTOR_029      default_isr     // GPIOC
#define VECTOR_030      default_isr     // GPIOD
#define VECTOR_031      default_isr     // GPIOE
#define VECTOR_032      default_isr     // GPIOF
#define VECTOR_033      default_isr     // Real Time Clock
#define VECTOR_034      default_isr     // RESERVED
#define VECTOR_035      default_isr     // RESERVED
#define VECTOR_036      default_isr     // RESERVED
#define VECTOR_037      default_isr     // RESERVED
#define VECTOR_038      default_isr     // RESERVED
#define VECTOR_039      default_isr     // RESERVED
#define VECTOR_040      default_isr     // SW Interrupt 0
#define VECTOR_041      default_isr     // SW Interrupt 1
#define VECTOR_042      default_isr     // SW Interrupt 2
#define VECTOR_043      default_isr     // SW Interrupt 3
#define VECTOR_044      default_isr     // SW Interrupt Low Priority
#define VECTOR_045      default_isr     // User Programmable L1 Interrupt
#define VECTOR_046      default_isr     // User Programmable L1 Interrupt
#define VECTOR_047      default_isr     // User Programmable L1 Interrupt
#define VECTOR_048      default_isr     // User Programmable L2 Interrupt
#define VECTOR_049      default_isr     // User Programmable L2 Interrupt
#define VECTOR_050      default_isr     // User Programmable L2 Interrupt (or Fast Interrupt)

/* Interrupt Vector Table Virtual Function */
extern void vector_table(void);
extern void vector_table_ram(void);

/* Use "pragma" to define section for interrupt vector table */
#pragma define_section VECTOR_TABLE "vectors.text" near_absolute RX
#pragma define_section VECTOR_TABLE_RAM "vectors_ram.text" near_absolute RX

#endif __VECTORS_H

/* End of "vectors.h" */
